/*global define */
/*jslint white: true, nomen: true */

/*
	treeLeaf:

	This object provides a mixin for each tree leaf item.
*/

define (
function() {
	'use strict';

	function identity (obj) {
		return obj;
	}

	function mixin (options0) {
		var options = options0 || {},
			parentL_ = options.parentLabel || "parent_",
			treeInfo_ = options.getTreeInfo || identity;

		return {
			setParent : function (parent, index0) {
				var info = treeInfo_(this);
				if (info[parentL_]) {
					info[parentL_].removeChild(this);
				}

				info[parentL_] = parent;
				
				if (this.callChangeNotifiers) {
					if (parent) {
						if (parent.callChangeNotifiers) {
							parent.callChangeNotifiers("childAdded", this);
						}
					} else {
						this.callChangeNotifiers("childRemoved");
					}
					this.callChangeNotifiers("parentChanged", index0);
				}				
			},

			getParent : function () {
				return treeInfo_(this)[parentL_];
			},

			/** 
			 * Get path relative to some ancestor node.
			 * Returns paths expected findNode...() functions.
			*/
			getPathRelativeTo : function (ancestor) {
				var parent = treeInfo_(this)[parentL_],
					parentPath;

				if (this === ancestor) {
					// TODO: extend findNode...() with support for current node.
					return "";
				}

				// otherwise, repeat for parent
				if (parent) {
					parentPath = parent.getPathRelativeTo(ancestor);
					if (parentPath === "") {
						return this.getName();
					}

					// else
					return parentPath + "/" + this.getName(); 
				}

				// or throw an error when there are no more parents to try
				throw new Error("getPathRelativeTo(): ancestor argument was not an ancestor.");
			},

			/**
			 * Get ancestor without a parent.
			 */
			getRoot : function () {
				var root = this, // will change to the real root
					parent = treeInfo_(root)[parentL_]; 

				while (parent) { 
					root = parent;
					parent = treeInfo_(root)[parentL_];
				}

				return root;
			}
		};
	}

	

	return mixin;
});
